﻿using FAQ.Repository.Contracts;
using FAQ.Entities.fixtures;

namespace FAQ.Repository
{
    public class QuestionRepository : IQuestionRepository
    {

        private static List<Entities.Question> Questions = FactoryVersion.GetQuestions();

        /// <inheritdoc/>
        public List<Entities.Question> FindAll()
        {
            return QuestionRepository.Questions;
        }

        /// <inheritdoc/>
        public void Add(Entities.Question Question)
        {

            bool Existe = QuestionRepository.Questions.Any(q => q.Titre == Question.Titre);

            if (!Existe)
            {
                QuestionRepository.Questions.Add(Question);

            }
        }

        /// <inheritdoc/>
        public void RemoveQuestion(int Id)
        {
            var QuestionASupp = this.FindAll().First(q => q.IdQuestion == Id);
            QuestionRepository.Questions.Remove(QuestionASupp);

        }

        /// <inheritdoc/>
        public List<Entities.Question> OrderBy()
        {
            return this
                .FindAll()
                .OrderBy(q => q.IdQuestion)
                .ThenBy(q => DateTime.Parse(q.Date_Creation))
                .ToList();
        }

        /// <inheritdoc/>
        public Entities.Question Last()
        {
            return this.FindAll().Last();
        }

    }
}
